/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusFspms_diag.h 50784 2015-01-14 10:22:46Z mark $

Description:
  This file contains definition of Profibus FSPMS Task diagnostic

**************************************************************************************/
#ifndef __PROFIBUS_FSPMS_DIAG_H
#define __PROFIBUS_FSPMS_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS FSPMS Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_INIT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Data Link Layer failed, bus parameter can not be configured.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_INIT_PACKET ((TLR_RESULT)0xC0090004L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_BUS_PARAMETER_REJECTED
//
// MessageText:
//
//  The specified bus parameter are rejected by the Data Link Layer.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_BUS_PARAMETER_REJECTED ((TLR_RESULT)0xC0090005L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_RSAP_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the SAPs failed, Data Link Layer cannot be configured.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_RSAP_PACKET ((TLR_RESULT)0xC0090006L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_RSAP_ACTIVATION_DENIED
//
// MessageText:
//
//  The activation of a RSAP in the DMPMS state machine denied by the Data Link Layer.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_RSAP_ACTIVATION_DENIED ((TLR_RESULT)0xC0090007L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SAP_ACTIVATION_DENIED
//
// MessageText:
//
//  The activation of a SAP in the DMPMS state machine denied by the Data Link Layer.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SAP_ACTIVATION_DENIED ((TLR_RESULT)0xC0090008L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_SAPDEACTIVATE_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to deactivate the SAPs failed, Data Link Layer cannot be configured.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_SAPDEACTIVATE_PACKET ((TLR_RESULT)0xC0090009L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SAP_DEACTIVATION_DENIED
//
// MessageText:
//
//  The deactivation of a SAP in the DMPMS state machine denied by the Data Link Layer.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SAP_DEACTIVATION_DENIED ((TLR_RESULT)0xC009000AL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_START_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to start the Data Link Layer failed, Data Link Layer cannot be started.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_START_PACKET ((TLR_RESULT)0xC009000BL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_DATAEXCHANGE_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to update the slaves data exchange buffer data failed, no Data Exchange update can be driven.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_DATAEXCHANGE_PACKET ((TLR_RESULT)0xC009000CL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_DIAG_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to update the slaves diagnostic data failed, no slave diag update can be driven.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_DIAG_PACKET ((TLR_RESULT)0xC009000DL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_CFG_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to update the slaves configuration data failed, no slave configuration update can be driven.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_CFG_PACKET ((TLR_RESULT)0xC009000EL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_RDINPUT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to update the slaves input data failed, no slave input update can be driven.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_RDINPUT_PACKET ((TLR_RESULT)0xC009000FL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SETVALUE_FAILED_PACKET
//
// MessageText:
//
//  Setting a specific Data Link value failed, value has not been set.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SETVALUE_FAILED_PACKET ((TLR_RESULT)0xC0090010L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_REPLY_UPDATE_FAILED_PACKET
//
// MessageText:
//
//  Updating a specific reply buffer failed, buffer has not been updated.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_REPLY_UPDATE_FAILED_PACKET ((TLR_RESULT)0xC0090011L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_PRM_IND_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the received Slave Parameter Data to the application failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_PRM_IND_PACKET ((TLR_RESULT)0xC0090012L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_CFG_IND_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the received Slave Configuration Data to the application failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_CFG_IND_PACKET ((TLR_RESULT)0xC0090013L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_SLAVE_ADD_CHG_IND_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the received Slave Set Slave Address command to the application failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_SLAVE_ADD_CHG_IND_PACKET ((TLR_RESULT)0xC0090014L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_MINTSDR_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to configure the minTsdr-Timer failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_MINTSDR_PACKET ((TLR_RESULT)0xC0090015L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_NEW_OUTP_IND_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the new output indication to the application failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_NEW_OUTP_IND_PACKET ((TLR_RESULT)0xC0090016L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_GLOBAL_CONTROL_IND_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the global control indication to the application failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_GLOBAL_CONTROL_IND_PACKET ((TLR_RESULT)0xC0090017L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_SAP_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Global Control SAP failed, Data Link Layer cannot be configured.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_NO_SAP_PACKET ((TLR_RESULT)0xC0090018L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_ALARM_RES_UNEXPECTED
//
// MessageText:
//
//  An Alarm response has been received while the ayclic State Machine is in "POWER-ON" state and has not been initialized yet.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_ALARM_RES_UNEXPECTED ((TLR_RESULT)0xC0090019L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_FSPMS_NO_STARTED_IND_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the start indication of the acyclic state machine to the application failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_FSPMS_NO_STARTED_IND_PACKET ((TLR_RESULT)0xC009001AL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_NO_RSAP_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to activate the server SAP of the acyclic state machine failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_NO_RSAP_PACKET ((TLR_RESULT)0xC009001BL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_RSAP_ACTIVATION_DENIED
//
// MessageText:
//
//  The activation of a RSAP in the MSAC1S state machine denied by the Data Link Layer.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_RSAP_ACTIVATION_DENIED ((TLR_RESULT)0xC009001CL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_LSDUZERO_NORESPONSE
//
// MessageText:
//
//  A DP-master network frame has been received in the MSAC1S state machine that has a zero length and no response was available.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_LSDUZERO_NORESPONSE ((TLR_RESULT)0xC009001DL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_REPLY_UPDATE_CONFIRMATION
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. In state "OPEN" a reply update confirmation has been received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_REPLY_UPDATE_CONFIRMATION ((TLR_RESULT)0xC009001EL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_ALREADY_STARTED
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. In state "OPEN" a new request to start has been received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_ALREADY_STARTED ((TLR_RESULT)0xC009001FL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_NO_REPLYUPDATE_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to update a response buffer failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_NO_REPLYUPDATE_PACKET ((TLR_RESULT)0xC0090020L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_REPLY_UPDATE_ERROR
//
// MessageText:
//
//  Updating a response buffer within the Data Link Layer entity failed. Servce has been rejected.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_REPLY_UPDATE_ERROR ((TLR_RESULT)0xC0090021L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_VS_WRES
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. In state "VS-WRES" an unexpected reply update confirmation has been received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_VS_WRES ((TLR_RESULT)0xC0090022L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_VS_SRES
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. In state "VS-SRES" an unexpected reply update confirmation has been received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_VS_SRES ((TLR_RESULT)0xC0090023L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_VS_SRES_IND
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. In state "VS-SRES" an unexpected reply indication has been received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_VS_SRES_IND ((TLR_RESULT)0xC0090024L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_AA_SRES
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. In state "AA-SRES" an erroneous reply update confirmation has been received.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_STATE_CONFLICT_AA_SRES ((TLR_RESULT)0xC0090025L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_SAP_DEACTIVATION_FAILED
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. A deactivation of an Service Access Point failed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_SAP_DEACTIVATION_FAILED ((TLR_RESULT)0xC0090026L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_FSPMS_NO_ALARM_ACK_IND_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send an Alarm Acknowledgement indication within the acyclic state machine to the application failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_FSPMS_NO_ALARM_ACK_IND_PACKET ((TLR_RESULT)0xC0090027L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_SET_SLAVE_DIAG_FAILED
//
// MessageText:
//
//  A conflict has been detected within the acyclic MSAC1S state machine. Requesting a Slave diagnostic failed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSAC1S_SET_SLAVE_DIAG_FAILED ((TLR_RESULT)0xC0090028L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_DL_ADD_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to configure the new DL Address failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_NO_DL_ADD_PACKET ((TLR_RESULT)0xC0090029L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_RETURN_PACKET_FAILED
//
// MessageText:
//
//  Returning a packet back to the origin failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_RETURN_PACKET_FAILED ((TLR_RESULT)0xC009002AL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_RETURN_PACKET_FAILED
//
// MessageText:
//
//  Returning a packet back to the origin failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_RETURN_PACKET_FAILED ((TLR_RESULT)0xC009002BL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_SEND_PACKET_FAILED
//
// MessageText:
//
//  Sending a packet failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_MSCY1S_SEND_PACKET_FAILED ((TLR_RESULT)0xC009002CL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SEND_PACKET_FAILED
//
// MessageText:
//
//  Sending a packet failed, service cannot be performed.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_DMPMS_SEND_PACKET_FAILED ((TLR_RESULT)0xC009002DL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_FSPMS_CONNECTION_TIMEOUT
//
// MessageText:
//
//  Timeout of the actual connection.
//
#define TLR_DIAG_E_PROFIBUS_FSPMS_CONNECTION_TIMEOUT ((TLR_RESULT)0xC009002EL)




#endif  //__PROFIBUS_FSPMS_DIAG_H

